<?php
// ARQUIVO DE TESTE - teste_sistema.php
// Acesse: http://172.16.253.44/layane/evento/teste_sistema.php

require_once 'config.php';

echo "<!DOCTYPE html>
<html lang='pt-BR'>
<head>
    <meta charset='UTF-8'>
    <title>Teste do Sistema</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
        .box { background: white; padding: 20px; margin: 20px 0; border-radius: 10px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        h1 { color: #667eea; }
        h2 { color: #333; border-bottom: 2px solid #667eea; padding-bottom: 10px; }
        .success { color: green; font-weight: bold; }
        .error { color: red; font-weight: bold; }
        table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        th, td { padding: 10px; text-align: left; border: 1px solid #ddd; }
        th { background: #667eea; color: white; }
        tr:nth-child(even) { background: #f9f9f9; }
        .url-test { background: #e7f3ff; padding: 15px; margin: 10px 0; border-radius: 5px; }
    </style>
</head>
<body>";

echo "<h1>🔍 Teste do Sistema - Evento Posse</h1>";

// 1. Testar conexão
echo "<div class='box'>";
echo "<h2>1. Conexão com Banco de Dados</h2>";
try {
    $pdo = getDBConnection();
    echo "<p class='success'>✅ Conexão OK!</p>";
    echo "<p><strong>URL_BASE configurada:</strong> " . URL_BASE . "</p>";
} catch (Exception $e) {
    echo "<p class='error'>❌ Erro: " . $e->getMessage() . "</p>";
    die();
}
echo "</div>";

// 2. Verificar registros
echo "<div class='box'>";
echo "<h2>2. Convites no Banco de Dados</h2>";
try {
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM convidados");
    $total = $stmt->fetch()['total'];
    
    echo "<p><strong>Total de convites:</strong> {$total}</p>";
    
    if ($total > 0) {
        echo "<h3>Todos os Convites:</h3>";
        $stmt = $pdo->query("SELECT * FROM convidados ORDER BY id ASC LIMIT 20");
        echo "<table>";
        echo "<tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Código (qrcode_hash)</th>
                <th>Imagem</th>
                <th>Confirmado</th>
                <th>Link</th>
              </tr>";
        
        while ($row = $stmt->fetch()) {
            $url = URL_BASE . '/confirmar.php?id=' . $row['id'];
            echo "<tr>";
            echo "<td><strong>" . $row['id'] . "</strong></td>";
            echo "<td>" . ($row['nome'] ?: '<em>Sem nome</em>') . "</td>";
            echo "<td><code>" . ($row['qrcode_hash'] ?: 'N/A') . "</code></td>";
            echo "<td>" . ($row['qrcode_image'] ?: 'N/A') . "</td>";
            echo "<td>" . ($row['confirmado'] ? '✅' : '⏳') . "</td>";
            echo "<td><a href='{$url}' target='_blank' style='color: #667eea; font-weight: bold;'>Testar</a></td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Testar primeiro convite
        $stmt = $pdo->query("SELECT * FROM convidados ORDER BY id ASC LIMIT 1");
        $primeiro = $stmt->fetch();
        
        if ($primeiro) {
            echo "<div class='url-test'>";
            echo "<h3>🧪 Teste com Primeiro Convite (ID: {$primeiro['id']})</h3>";
            $url_teste = URL_BASE . '/confirmar.php?id=' . $primeiro['id'];
            echo "<p><strong>URL Completa:</strong></p>";
            echo "<p><a href='{$url_teste}' target='_blank' style='font-size: 16px;'>{$url_teste}</a></p>";
            echo "<p><button onclick=\"window.open('{$url_teste}', '_blank')\" style='padding: 10px 20px; background: #667eea; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 16px;'>Abrir em Nova Aba</button></p>";
            echo "</div>";
        }
        
    } else {
        echo "<p class='error'>❌ Nenhum convite encontrado! Execute gerar.php primeiro.</p>";
    }
    
} catch (Exception $e) {
    echo "<p class='error'>❌ Erro: " . $e->getMessage() . "</p>";
}
echo "</div>";

// 3. Testar ID específico (35)
echo "<div class='box'>";
echo "<h2>3. Teste com ID 35 (do seu erro)</h2>";
try {
    $stmt = $pdo->prepare("SELECT * FROM convidados WHERE id = :id");
    $stmt->execute([':id' => 35]);
    $conv35 = $stmt->fetch();
    
    if ($conv35) {
        echo "<p class='success'>✅ Convite ID 35 existe!</p>";
        echo "<table>";
        echo "<tr><th>Campo</th><th>Valor</th></tr>";
        echo "<tr><td>ID</td><td>{$conv35['id']}</td></tr>";
        echo "<tr><td>Nome</td><td>" . ($conv35['nome'] ?: '<em>Não atribuído</em>') . "</td></tr>";
        echo "<tr><td>Código</td><td>{$conv35['qrcode_hash']}</td></tr>";
        echo "<tr><td>Imagem</td><td>{$conv35['qrcode_image']}</td></tr>";
        echo "<tr><td>Confirmado</td><td>" . ($conv35['confirmado'] ? 'Sim' : 'Não') . "</td></tr>";
        echo "</table>";
        
        $url35 = URL_BASE . '/confirmar.php?id=35';
        echo "<div class='url-test'>";
        echo "<h3>Link para ID 35:</h3>";
        echo "<p><a href='{$url35}' target='_blank'>{$url35}</a></p>";
        echo "<p><button onclick=\"window.open('{$url35}', '_blank')\" style='padding: 10px 20px; background: #28a745; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 16px;'>Testar ID 35</button></p>";
        echo "</div>";
    } else {
        echo "<p class='error'>❌ Convite ID 35 NÃO EXISTE no banco!</p>";
        echo "<p>Isso explica o erro 'Convite Inválido'.</p>";
    }
} catch (Exception $e) {
    echo "<p class='error'>❌ Erro: " . $e->getMessage() . "</p>";
}
echo "</div>";

// 4. Verificar arquivos
echo "<div class='box'>";
echo "<h2>4. Verificar Arquivos do Sistema</h2>";

$arquivos = [
    'config.php' => 'Configurações',
    'gerar.php' => 'Gerador de QR Codes',
    'confirmar.php' => 'Página de Confirmação',
    'logoo.png' => 'Logo',
    'foto.jpeg' => 'Foto do Modal'
];

echo "<table>";
echo "<tr><th>Arquivo</th><th>Descrição</th><th>Status</th></tr>";
foreach ($arquivos as $arquivo => $desc) {
    $existe = file_exists($arquivo);
    $status = $existe ? "<span class='success'>✅ Existe</span>" : "<span class='error'>❌ Não existe</span>";
    echo "<tr><td><code>{$arquivo}</code></td><td>{$desc}</td><td>{$status}</td></tr>";
}
echo "</table>";

if (is_dir('qrcodes')) {
    $qr_count = count(glob('qrcodes/*.png'));
    echo "<p><strong>Diretório qrcodes/:</strong> <span class='success'>✅ Existe ({$qr_count} arquivos)</span></p>";
} else {
    echo "<p><strong>Diretório qrcodes/:</strong> <span class='error'>❌ Não existe</span></p>";
}
echo "</div>";

// 5. Instruções
echo "<div class='box'>";
echo "<h2>5. ⚠️ Como Resolver</h2>";
echo "<p><strong>Se o ID 35 não existe:</strong></p>";
echo "<ol>";
echo "<li>Acesse <a href='gerar.php'>gerar.php</a></li>";
echo "<li>Gere pelo menos 35 QR codes</li>";
echo "<li>Volte aqui e teste novamente</li>";
echo "</ol>";

echo "<p><strong>Se os arquivos não existem:</strong></p>";
echo "<ol>";
echo "<li>Certifique-se de que todos os arquivos (.php e imagens) estão na raiz do projeto</li>";
echo "<li>Verifique as permissões dos arquivos</li>";
echo "<li>Crie o diretório qrcodes/ se não existir: <code>mkdir qrcodes && chmod 755 qrcodes</code></li>";
echo "</ol>";
echo "</div>";

echo "</body></html>";
?>