<?php
session_start();

// CREDENCIAIS FIXAS DO SISTEMA
define('USUARIO_ADMIN', 'admin');
define('SENHA_ADMIN', 'Assego@123');

// Se já estiver logado, redireciona para admin
if (isset($_SESSION['usuario_logado']) && $_SESSION['usuario_logado'] === true) {
    header('Location: admin.php');
    exit;
}

$erro = '';

// Processar login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = trim($_POST['usuario'] ?? '');
    $senha = $_POST['senha'] ?? '';
    
    if (empty($usuario) || empty($senha)) {
        $erro = 'Por favor, preencha todos os campos';
    } else {
        // Verificar credenciais fixas
        if ($usuario === USUARIO_ADMIN && $senha === SENHA_ADMIN) {
            // Login bem-sucedido
            $_SESSION['usuario_logado'] = true;
            $_SESSION['usuario_nome'] = 'Administrador';
            $_SESSION['login_time'] = time();
            
            header('Location: admin.php');
            exit;
        } else {
            $erro = 'Usuário ou senha inválidos';
        }
    }
}

// Mensagem de logout
$logout_msg = '';
if (isset($_GET['logout'])) {
    $logout_msg = 'Você saiu do sistema com sucesso!';
}
if (isset($_GET['timeout'])) {
    $erro = 'Sua sessão expirou. Faça login novamente.';
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sistema Evento Posse</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #0a1465 0%, #081050 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .login-container {
            background: white;
            border-radius: 20px;
            padding: 50px 40px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 450px;
            width: 100%;
        }
        
        .logo-container {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo-container img {
            width: 120px;
            height: auto;
            margin-bottom: 20px;
        }
        
        h1 {
            text-align: center;
            color: #333;
            font-size: 28px;
            margin-bottom: 10px;
        }
        
        .subtitle {
            text-align: center;
            color: #666;
            font-size: 14px;
            margin-bottom: 40px;
        }
        
        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            text-align: center;
            animation: slideIn 0.3s;
        }
        
        @keyframes slideIn {
            from {
                transform: translateY(-20px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 2px solid #f5c6cb;
        }
        
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 2px solid #c3e6cb;
        }
        
        .form-group {
            margin-bottom: 25px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }
        
        .form-group input {
            width: 100%;
            padding: 15px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 16px;
            transition: all 0.3s;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #0a1465;
            box-shadow: 0 0 0 3px rgba(10, 20, 101, 0.1);
        }
        
        .form-group input::placeholder {
            color: #999;
        }
        
        .password-toggle {
            position: relative;
        }
        
        .password-toggle button {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #666;
            cursor: pointer;
            font-size: 18px;
            padding: 5px;
        }
        
        .password-toggle button:hover {
            color: #0a1465;
        }
        
        .btn {
            width: 100%;
            padding: 15px;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            background: linear-gradient(135deg, #0a1465 0%, #081050 100%);
            color: white;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(10, 20, 101, 0.4);
        }
        
        .btn:disabled {
            background: #ccc;
            cursor: not-allowed;
            transform: none;
        }
        
        .info-box {
            background: #e7f3ff;
            border-left: 4px solid #2196F3;
            padding: 15px;
            margin-top: 25px;
            border-radius: 8px;
            font-size: 13px;
            color: #555;
        }
        
        .info-box strong {
            color: #1976D2;
        }
        
        .footer {
            text-align: center;
            margin-top: 30px;
            color: #999;
            font-size: 13px;
        }
        
        @media (max-width: 500px) {
            .login-container {
                padding: 40px 25px;
            }
            
            h1 {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo-container">
            <img src="logoass.png" alt="Logo" onerror="this.style.display='none'">
            <h1>🔐 Acesso Restrito</h1>
            <p class="subtitle">Sistema de Gerenciamento de Eventos</p>
        </div>
        
        <?php if ($logout_msg): ?>
            <div class="alert alert-success">
                ✓ <?= htmlspecialchars($logout_msg) ?>
            </div>
        <?php endif; ?>
        
        <?php if ($erro): ?>
            <div class="alert alert-error">
                ⚠️ <?= htmlspecialchars($erro) ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" id="formLogin">
            <div class="form-group">
                <label for="usuario">👤 Usuário</label>
                <input type="text" 
                       id="usuario" 
                       name="usuario" 
                       placeholder="Digite seu usuário" 
                       required 
                       autofocus
                       autocomplete="username"
                       value="<?= isset($_POST['usuario']) ? htmlspecialchars($_POST['usuario']) : '' ?>">
            </div>
            
<div class="form-group">
                <label for="senha">🔒 Senha</label>
                <div class="password-toggle">
                    <input type="password" 
                           id="senha" 
                           name="senha" 
                           placeholder="Digite sua senha" 
                           required
                           autocomplete="current-password">
                    <button type="button" onclick="togglePassword()" id="btnToggle" tabindex="-1">
                        👁
                    </button>
                </div>
            </div>
            
            <button type="submit" class="btn" id="btnLogin">
                → Entrar
            </button>
        </form>
        
        <div class="info-box">
            <strong>ℹ️ Informação:</strong><br>
            Este é um sistema restrito. Apenas usuários autorizados podem acessar o painel administrativo.
        </div>
    </div>

    <script>
        function togglePassword() {
            const senhaInput = document.getElementById('senha');
            const btnToggle = document.getElementById('btnToggle');
            
            if (senhaInput.type === 'password') {
                senhaInput.type = 'text';
                btnToggle.textContent = '✕';
            } else {
                senhaInput.type = 'password';
                btnToggle.textContent = '👁';
            }
        }
        
        // Prevenir múltiplos submits
        document.getElementById('formLogin').addEventListener('submit', function(e) {
            const btnLogin = document.getElementById('btnLogin');
            btnLogin.disabled = true;
            btnLogin.textContent = '⏳ Verificando...';
        });
        
        // Auto-focus no campo usuário
        window.onload = function() {
            document.getElementById('usuario').focus();
        };
    </script>
</body>
</html>
