<?php
require_once 'config.php';

if (isset($_GET['hash'])) {
    $hash = $_GET['hash'];

    $pdo = getDBConnection();

    $stmt = $pdo->prepare("SELECT qrcode_image FROM convidados WHERE qrcode_hash = :hash");
    $stmt->execute([':hash' => $hash]);
    $result = $stmt->fetch();

    if ($result && $result['qrcode_image']) {
        $filepath = 'qrcodes/' . $result['qrcode_image'];

        if (file_exists($filepath)) {
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . filesize($filepath));
            readfile($filepath);
            exit;
        } else {
            die("Arquivo QR Code não encontrado.");
        }
    } else {
        die("QR Code inválido ou não encontrado no banco de dados.");
    }
} else {
    die("Hash do QR Code não fornecido.");
}
?>
