<?php
require_once 'config.php';

$pdo = getDBConnection();
$erro = false;
$sucesso = false;
$convidado = null;

// Verificar ID
if (isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM convidados WHERE id = :id");
        $stmt->execute([':id' => $id]);
        $convidado = $stmt->fetch();
        
        if (!$convidado) {
            $erro = "Convite não encontrado.";
        }
    } catch (Exception $e) {
        $erro = "Erro ao buscar informações: " . $e->getMessage();
    }
} else {
    $erro = "Código de confirmação não fornecido.";
}

// Processar confirmação
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $convidado && !$erro) {
    $resposta = $_POST['resposta'] ?? '';
    
    if ($resposta === 'sim') {
        // Confirmar presença
        try {
            $stmt = $pdo->prepare("UPDATE convidados SET confirmado = 1, data_cadastro = NOW() WHERE id = :id");
            $stmt->execute([':id' => $convidado['id']]);
            
            $sucesso = "confirmado";
            $convidado['confirmado'] = 1;
        } catch (Exception $e) {
            $erro = "Erro ao confirmar presença: " . $e->getMessage();
        }
        
    } elseif ($resposta === 'nao') {
        // Recusar
        try {
            $stmt = $pdo->prepare("UPDATE convidados SET confirmado = 0 WHERE id = :id");
            $stmt->execute([':id' => $convidado['id']]);
            
            $sucesso = "recusado";
            $convidado['confirmado'] = 0;
        } catch (Exception $e) {
            $erro = "Erro ao registrar resposta: " . $e->getMessage();
        }
    }
}

// Check-in
if (isset($_GET['checkin']) && $convidado && $convidado['confirmado']) {
    try {
        $stmt = $pdo->prepare("UPDATE convidados SET presente = 1, data_checkin = NOW() WHERE id = :id");
        $stmt->execute([':id' => $convidado['id']]);
        $convidado['presente'] = 1;
    } catch (Exception $e) {
        $erro = "Erro ao realizar check-in: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CONVITE – SOLENIDADE DE POSSE ASSEGO 2026/2029</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #0a2463 0%, #1e3a8a 50%, #0a2463 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            position: relative;
        }

        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 50%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(255, 255, 255, 0.1) 0%, transparent 50%);
            pointer-events: none;
        }
        
        .card {
            background: rgba(255, 255, 255, 0.98);
            border-radius: 20px;
            padding: 40px;
            max-width: 500px;
            width: 100%;
            box-shadow: 0 20px 60px rgba(0,0,0,0.4);
            position: relative;
            z-index: 1;
        }
        
        .header-icon {
            text-align: center;
            font-size: 50px;
            margin-bottom: 20px;
        }

        .logo-header {
            display: block;
            margin: 0 auto 20px;
            width: 120px;
            height: auto;
        }
        
        h1 {
            text-align: center;
            color: #0a2463;
            margin-bottom: 5px;
            font-size: 24px;
            font-weight: 700;
        }
        
        .subtitle {
            text-align: center;
            color: #1e3a8a;
            margin-bottom: 30px;
            font-size: 14px;
            font-weight: 500;
        }
        
        .ingresso-info {
            background: #f8fafc;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 30px;
            border: 2px solid #e2e8f0;
        }
        
        .ingresso-numero {
            background: linear-gradient(135deg, #0a2463 0%, #1e3a8a 100%);
            color: white;
            display: inline-block;
            padding: 8px 20px;
            border-radius: 20px;
            font-weight: bold;
            font-size: 18px;
            margin-bottom: 15px;
        }
        
        .ingresso-nome {
            font-size: 20px;
            font-weight: 600;
            color: #0a2463;
            margin-bottom: 10px;
        }
        
        .ingresso-status {
            display: inline-block;
            padding: 6px 15px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
        }
        
        .status-atribuido {
            background: #fef3c7;
            color: #92400e;
        }
        
        .status-confirmado {
            background: #d1fae5;
            color: #065f46;
        }
        
        .status-presente {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .mesa-info {
            margin-top: 10px;
            padding: 10px;
            background: #fef3c7;
            border-radius: 8px;
            color: #92400e;
            font-size: 14px;
            border-left: 4px solid #fbbf24;
        }
        
        .form-group {
            background: #f8fafc;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 20px;
            border: 2px solid #e2e8f0;
        }
        
        .form-group h3 {
            color: #0a2463;
            margin-bottom: 15px;
            font-size: 16px;
            font-weight: 600;
        }
        
        .texto-apresentacao {
            background: white;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 15px;
            line-height: 1.6;
            color: #1e293b;
            border: 1px solid #e2e8f0;
        }
        
        .texto-apresentacao strong {
            color: #0a2463;
        }
        
        .radio-option {
            background: white;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 10px;
            cursor: pointer;
            border: 2px solid #cbd5e1;
            transition: all 0.3s;
            display: flex;
            align-items: center;
        }
        
        .radio-option:hover {
            border-color: #1e3a8a;
        }
        
        .radio-option.selected {
            border-color: #1e3a8a;
            background: #eff6ff;
        }
        
        .radio-option input[type="radio"] {
            margin-right: 10px;
            width: 20px;
            height: 20px;
            cursor: pointer;
            accent-color: #1e3a8a;
        }
        
        .radio-option label {
            cursor: pointer;
            flex: 1;
            font-size: 14px;
            color: #334155;
        }
        
        .btn {
            width: 100%;
            padding: 15px;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #0a2463 0%, #1e3a8a 100%);
            color: white;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(10, 36, 99, 0.4);
        }

        .btn-primary:disabled {
            background: #94a3b8;
            cursor: not-allowed;
            transform: none;
        }
        
        .alert {
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .alert-success {
            background: #d1fae5;
            color: #065f46;
            border: 2px solid #6ee7b7;
        }
        
        .alert-info {
            background: #dbeafe;
            color: #1e40af;
            border: 2px solid #93c5fd;
        }
        
        .alert-error {
            background: #fee2e2;
            color: #991b1b;
            border: 2px solid #fca5a5;
        }
        
        .alert-icon {
            font-size: 40px;
            margin-bottom: 10px;
        }
        
        .alert h2 {
            font-size: 20px;
            margin-bottom: 10px;
        }
        
        .evento-info {
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            padding: 20px;
            border-radius: 12px;
            margin-top: 20px;
            font-size: 14px;
            color: #475569;
            line-height: 1.8;
            border-left: 4px solid #fbbf24;
        }
        
        .evento-info strong {
            color: #0a2463;
        }

        .evento-info .destaque {
            background: #0a2463;
            color: white;
            padding: 12px;
            border-radius: 8px;
            margin-top: 10px;
            text-align: center;
            font-weight: 600;
        }

        .assinatura {
            margin-top: 20px;
            padding-top: 15px;
            border-top: 2px solid #e2e8f0;
            text-align: center;
            font-size: 14px;
            color: #475569;
            line-height: 1.6;
            position: relative;
            min-height: 120px;
        }

        /* CLASSE NOVA PARA CORRIGIR A SOBREPOSIÇÃO NO TEXTO DE CIMA */
        .texto-superior {
            position: relative;
            z-index: 2;
        }

        .assinatura strong {
            color: #0a2463;
            display: block;
            margin-top: 5px;
            position: relative;
            z-index: 2;
        }

        .assinatura-imagem {
            position: absolute;
            left: 50%;
            bottom: -30px;
            transform: translateX(-50%);
            width: 150px;
            height: auto;
            opacity: 0.50;
            filter: grayscale(30%);
            z-index: 1;
            pointer-events: none;
        }

        .mapa-container {
            margin-top: 15px;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .mapa-container iframe {
            width: 100%;
            height: 200px;
            border: none;
            display: block;
        }
        
        .hint {
            text-align: center;
            color: #64748b;
            font-size: 13px;
            margin-top: 15px;
        }

        /* Estilos do Modal de Boas-Vindas */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(10, 36, 99, 0.9);
            animation: fadeIn 0.3s;
        }

        .modal.show {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .modal-content {
            background-color: #ffffff;
            margin: auto;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 30px 60px rgba(0,0,0,0.6);
            width: 90%;
            max-width: 450px;
            text-align: center;
            position: relative;
            animation: slideUp 0.4s;
        }

        @keyframes slideUp {
            from {
                transform: translateY(50px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        .close-button {
            color: #94a3b8;
            position: absolute;
            top: 15px;
            right: 25px;
            font-size: 32px;
            font-weight: bold;
            cursor: pointer;
            transition: color 0.3s;
        }

        .close-button:hover,
            .close-button:focus {
            color: #0a2463;
            text-decoration: none;
            cursor: pointer;
        }

        .modal-logos {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 20px;
            margin-bottom: 20px;
        }

        .modal-logo {
            width: 120px;
            height: auto;
        }

        .modal-body {
            margin-top: 10px;
        }

        .modal-body h2 {
            color: #0a2463;
            margin-bottom: 20px;
            font-size: 28px;
            font-weight: 700;
        }

        .modal-body .mensagem-confirmacao {
            background: #d1fae5;
            color: #065f46;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 20px;
            border: 2px solid #6ee7b7;
            font-size: 16px;
            line-height: 1.6;
        }

        .modal-body .mensagem-recusa {
            background: #dbeafe;
            color: #1e40af;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 20px;
            border: 2px solid #93c5fd;
            font-size: 16px;
            line-height: 1.6;
        }

        .modal-body .mesa-destaque {
            background: #fef3c7;
            color: #92400e;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 15px;
            border-left: 4px solid #fbbf24;
            font-weight: 600;
        }

        .modal-body .evento-detalhes {
            text-align: left;
            font-size: 14px;
            color: #475569;
            line-height: 1.8;
            margin-bottom: 20px;
        }

        .modal-body .evento-detalhes strong {
            color: #0a2463;
        }

        .profile-section {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 25px;
            margin-bottom: 20px;
            padding-top: 20px;
            border-top: 2px solid #e2e8f0;
        }

        .profile-pic {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            object-fit: cover;
            border: 5px solid #1e3a8a;
            box-shadow: 0 10px 25px rgba(30, 58, 138, 0.3);
            flex-shrink: 0;
        }

        .instagram-button {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            background: linear-gradient(45deg, #f09433 0%, #e6683c 25%, #dc2743 50%, #cc2366 75%, #bc1888 100%);
            color: white;
            padding: 15px 30px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            font-size: 16px;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(188, 24, 136, 0.3);
            white-space: nowrap;
        }

        .instagram-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(188, 24, 136, 0.4);
        }

        .instagram-icon {
            width: 24px;
            height: 24px;
            fill: white;
        }

        /* Responsivo para telas menores */
        @media (max-width: 600px) {
            .profile-section {
                flex-direction: column;
                gap: 20px;
            }
            
            .modal-content {
                padding: 30px 20px;
            }

            .modal-logos {
                gap: 15px;
            }

            .modal-logo {
                width: 90px;
            }

            .card {
                padding: 30px 20px;
            }

            .logo-header {
                width: 150px;
            }

            .assinatura-imagem {
                width: 130px;
                bottom: -5px;
            }
            
            .assinatura {
                min-height: 100px;
            }
        }
    </style>
</head>
<body>
    <div id="confirmacaoModal" class="modal">
        <div class="modal-content">
            <span class="close-button" onclick="closeModal()">×</span>
            
            <div class="modal-logos">
                <img src="logoass.png" alt="Logo ASSEGO" class="modal-logo">
            </div>
            
            <div class="modal-body" id="modalBody">
                </div>
        </div>
    </div>

    <div class="card">
        <?php if ($erro): ?>
            <div class="header-icon">❌</div>
            <h1>Ops!</h1>
            <div class="alert alert-error">
                <div class="alert-icon">⚠️</div>
                <p><?= htmlspecialchars($erro) ?></p>
            </div>
        
        <?php elseif ($convidado['presente']): ?>
            <img src="logoass.png" alt="Logo ASSEGO" class="logo-header">
            <h1>CONVITE – SOLENIDADE DE POSSE ASSEGO 2026/2029</h1>
            <div class="header-icon">✅</div>
            <h1>Check-in Realizado!</h1>
            <div class="subtitle">Seja bem-vindo(a) ao evento!</div>
            
            <div class="alert alert-success">
                <div class="alert-icon">🎉</div>
                <h2>Presença Confirmada</h2>
                <p>Você já realizou o check-in.</p>
            </div>
            
            <div class="ingresso-info">
                <div class="ingresso-nome"><?= htmlspecialchars($convidado['nome']) ?></div>
                <div>
                    <span class="ingresso-status status-presente">✓ Check-in Realizado</span>
                </div>
                <?php if ($convidado['compor_mesa']): ?>
                <div class="mesa-info">
                    👥 <strong>Composição de Mesa Diretora</strong><br>
                    Convidado(a) para compor a Mesa Diretora da Solenidade.
                </div>
                <?php endif; ?>
            </div>
            
            <div class="evento-info">
                <strong>📅 Data:</strong> 09 de janeiro de 2026 (sexta-feira)<br>
                <strong>⏰ Horário:</strong> 18h<br>
                <strong>🍽️ Jantar:</strong> 19h<br>
                <strong>📍 Local:</strong> Sede Administrativa da ASSEGO<br>
                <strong>Endereço:</strong> Rua 87, nº 561, Setor Sul, Goiânia/GO<br>
                <a href="https://maps.app.goo.gl/MSBNygk9Wy3Jq45k8" target="_blank" style="color: #0a2463; font-weight: 600; text-decoration: none; display: inline-flex; align-items: center; gap: 5px; margin-top: 5px;">
                    🗺️ Ver no mapa
                </a>
            </div>

            <div class="assinatura">
                <span class="texto-superior">
                    A sua presença muito nos honrará.<br>
                    Com nossos melhores cumprimentos,
                </span><br>
                <strong>Subtenente Sérgio<br>Presidente da ASSEGO</strong>
                <img src="ass.jpeg" alt="Assinatura" class="assinatura-imagem">
            </div>
        
        <?php else: ?>
            <img src="logoass.png" alt="Logo ASSEGO" class="logo-header">
            <h1>CONVITE – SOLENIDADE DE POSSE ASSEGO 2026/2029</h1>
            
            <form method="POST" id="formConfirmacao" onsubmit="return handleSubmit(event)">
                <div class="texto-apresentacao">
                    <?php if ($convidado['compor_mesa']): ?>
                        O Subtenente Sérgio, Presidente reeleito da Associação dos Subtenentes e Sargentos do Estado de Goiás (ASSEGO), tem a honra de convidar <strong><?= htmlspecialchars($convidado['nome']) ?></strong> para compor a Mesa Diretora da Solenidade de Posse da Diretoria Executiva e do Conselho Fiscal – Gestão 2026/2029.
                    <?php else: ?>
                        O Subtenente Sérgio, Presidente reeleito da Associação dos Subtenentes e Sargentos do Estado de Goiás (ASSEGO), tem a honra de convidar para a Solenidade de Posse da Diretoria Executiva e do Conselho Fiscal – Gestão 2026/2029.
                    <?php endif; ?>
                </div>
                
                <div class="evento-info" style="margin-top: 0; margin-bottom: 20px;">
                    <strong>📅 Data:</strong> 09 de janeiro de 2026 (sexta-feira)<br>
                    <strong>⏰ Horário:</strong> 18h<br>
                    <strong>🍽️ Jantar:</strong> 19h<br>
                    <strong>📍 Local:</strong> Sede Administrativa da ASSEGO<br>
                    <strong>Endereço:</strong> Rua 87, nº 561, Setor Sul, Goiânia/GO<br>
                    <a href="https://maps.app.goo.gl/MSBNygk9Wy3Jq45k8" target="_blank" style="color: #0a2463; font-weight: 600; text-decoration: none; display: inline-flex; align-items: center; gap: 5px; margin-top: 5px;">
                        🗺️ Ver no mapa
                    </a>
                </div>
                
                <div class="form-group">
                    <h3>Confirmação de presença:</h3>
                    
                    <div class="radio-option" onclick="selectOption('sim')">
                        <input type="radio" name="resposta" value="sim" id="radio-sim" <?= $convidado['confirmado'] ? 'checked' : '' ?>>
                        <label for="radio-sim">Sim, confirmo minha presença.</label>
                    </div>
                    
                    <div class="radio-option" onclick="selectOption('nao')">
                        <input type="radio" name="resposta" value="nao" id="radio-nao" <?= (!$convidado['confirmado']) ? 'checked' : '' ?>>
                        <label for="radio-nao">Infelizmente, não poderei comparecer.</label>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    Confirmar Resposta
                </button>
            </form>

            <div class="assinatura">
                <span class="texto-superior">
                    A sua presença muito nos honrará.<br>
                    Com nossos melhores cumprimentos,
                </span><br>
                <strong>Subtenente Sérgio<br>Presidente da ASSEGO</strong>
                <img src="ass.jpeg" alt="Assinatura" class="assinatura-imagem">
            </div>
    
        <?php endif; ?>
    </div>

    <script>
        const dadosConvidado = {
            nome: <?= json_encode($convidado['nome'] ?? '') ?>,
            comporMesa: <?= json_encode($convidado['compor_mesa'] ?? false) ?>,
            id: <?= json_encode($convidado['id'] ?? 0) ?>
        };
        const sucessoPost = <?= json_encode($sucesso) ?>;
    </script>

    <script>
        function selectOption(opcao) {
            const radioElement = document.getElementById("radio-" + opcao);
            if (radioElement) {
                radioElement.checked = true;
                const options = document.querySelectorAll(".radio-option");
                options.forEach(opt => opt.classList.remove("selected"));
                if (opcao === "sim") {
                    options[0].classList.add("selected");
                } else {
                    options[1].classList.add("selected");
                }
            }
        }

        function closeModal() {
            const modal = document.getElementById('confirmacaoModal');
            if (modal) {
                modal.classList.remove('show');
            }
        }

        function handleSubmit(event) {
            // Deixa o formulário enviar normalmente
            return true;
        }

        function mostrarModalConfirmacao(resposta, comporMesa, nomeConvidado) {
            const modalBody = document.getElementById('modalBody');
            let conteudo = '';

            if (resposta === 'sim') {
                conteudo = '<h2>🎉 Presença Confirmada!</h2>';
                conteudo += '<div class="mensagem-confirmacao">';
                conteudo += '<p><strong>Agradecemos imensamente pela confirmação de sua presença!</strong></p>';
                conteudo += '</div>';
            } else {
                conteudo = '<h2> Resposta Registrada</h2>';
                conteudo += '<div class="mensagem-recusa">';
                conteudo += '<p><strong>Agradecemos imensamente pelo retorno.</strong></p>';
                conteudo += '</div>';
            }

            // Adiciona informações do evento
            conteudo += '<div class="evento-detalhes">';
            conteudo += '<strong>📅 Data:</strong> 09 de janeiro de 2026 (sexta-feira)<br>';
            conteudo += '<strong>⏰ Horário:</strong> 18h<br>';
            conteudo += '<strong>🍽️ Jantar:</strong> 19h<br>';
            conteudo += '<strong>📍 Local:</strong> Sede Administrativa da ASSEGO<br>';
            conteudo += '<strong>Endereço:</strong> Rua 87, nº 561, Setor Sul, Goiânia/GO<br>';
            conteudo += '<a href="https://maps.app.goo.gl/MSBNygk9Wy3Jq45k8" target="_blank" style="color: #0a2463; font-weight: 600; text-decoration: none; display: inline-flex; align-items: center; gap: 5px; margin-top: 5px;">';
            conteudo += '🗺️ Ver no mapa';
            conteudo += '</a>';
            conteudo += '<div class="mapa-container" style="margin-top: 15px; border-radius: 8px; overflow: hidden; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">';
            conteudo += '<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3821.8287516557675!2d-49.2657!3d-16.6867!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x935ef0f00ba8c5f7%3A0x4e59e3e4e5e5e5e5!2sRua%2087%2C%20Setor%20Sul%2C%20Goi%C3%A2nia%20-%20GO!5e0!3m2!1spt-BR!2sbr!4v1234567890123!5m2!1spt-BR!2sbr" width="100%" height="200" style="border:none;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>';
            conteudo += '</div>';
            conteudo += '</div>';
            conteudo += '<div class="assinatura" style="position: relative; min-height: 120px;">';
            // APLICADO STYLE DIRETO AQUI PARA GARANTIR NO MODAL TAMBÉM
            conteudo += '<span style="position: relative; z-index: 2;">A sua presença muito nos honrará.<br>';
            conteudo += 'Com nossos melhores cumprimentos,</span><br>';
            conteudo += '<strong style="position: relative; z-index: 2;">Subtenente Sérgio<br>Presidente da ASSEGO</strong>';
            conteudo += '<img src="ass.jpeg" alt="Assinatura" style="position: absolute; left: 50%; bottom: -5px; transform: translateX(-50%); width: 150px; opacity: 0.60; filter: grayscale(30%); z-index: 1; pointer-events: none;">';
            conteudo += '</div>';

            // Adiciona seção de redes sociais
            conteudo += '<div class="profile-section">';
            conteudo += '<div style="text-align: center; width: 100%;">';
            conteudo += '<p style="margin-bottom: 15px; color: #64748b; font-size: 14px;">Acompanhe na rede social:</p>';
            conteudo += '<a href="https://www.instagram.com/sergio_assego/" target="_blank" class="instagram-button">';
            conteudo += '<svg class="instagram-icon" viewBox="0 0 24 24" fill="currentColor">';
            conteudo += '<path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>';
            conteudo += '</svg>';
            conteudo += '@sergio_assego';
            conteudo += '</a>';
            conteudo += '</div>';
            conteudo += '</div>';

            modalBody.innerHTML = conteudo;
            
            const modal = document.getElementById('confirmacaoModal');
            modal.classList.add('show');
        }
        
        window.onload = function() {
            // Marcar opção selecionada
            const radioSim = document.getElementById("radio-sim");
            const radioNao = document.getElementById("radio-nao");
            const radioOptions = document.querySelectorAll(".radio-option");
            
            if (radioSim && radioSim.checked && radioOptions.length > 0) {
                radioOptions[0].classList.add("selected");
            }
            if (radioNao && radioNao.checked && radioOptions.length > 1) {
                radioOptions[1].classList.add("selected");
            }

            // Mostrar modal se acabou de enviar o formulário
            if (sucessoPost === 'confirmado') {
                mostrarModalConfirmacao('sim', dadosConvidado.comporMesa, dadosConvidado.nome);
            } else if (sucessoPost === 'recusado') {
                mostrarModalConfirmacao('nao', false, dadosConvidado.nome);
            }
        };

        // Fechar modal clicando fora do conteúdo
        const modalElement = document.getElementById('confirmacaoModal');
        if (modalElement) {
            modalElement.addEventListener('click', function(e) {
                if (e.target === this) {
                    closeModal();
                }
            });
        }

        // Fechar modal com ESC
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeModal();
            }
        });
    </script>
</body>
</html>