<?php
// Configurações do banco de dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'evento_posse');
define('DB_USER', 'layane');
define('DB_PASS', '92106115@Lore');
define('DB_CHARSET', 'utf8mb4');

// Configurações do sistema
define('URL_BASE', 'http://172.16.253.44/layane/evento-1'); // Ajuste conforme seu ambiente

// Conexão com o banco de dados
function getDBConnection() {
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];
        
        $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        return $pdo;
    } catch (PDOException $e) {
        die("Erro na conexão com o banco de dados: " . $e->getMessage());
    }
}

// Função para gerar hash único e melhorado
function gerarHash($id) {
    // Gerar hash mais robusto usando múltiplos fatores
    $salt = 'evento_posse_2025'; // Sal fixo para o evento
    $timestamp = microtime(true);
    $random = bin2hex(random_bytes(16));
    
    $data = $id . $salt . $timestamp . $random;
    return hash('sha256', $data);
}

// Função para formatar número
function formatarNumero($numero) {
    return str_pad($numero, 4, '0', STR_PAD_LEFT);
}

// Função para gerar identificação completa do QR Code
function gerarIdentificacao($numero) {
    $data_atual = date('Y-m-d');
    $numero_formatado = formatarNumero($numero);
    return $data_atual . '-' . $numero_formatado;
}
?>