<?php
/**
 * Middleware de Autenticação
 * Inclua este arquivo no início de todas as páginas protegidas:
 * require_once 'auth.php';
 */

// Iniciar sessão se ainda não foi iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verificar se o usuário está logado
if (!isset($_SESSION['usuario_logado']) || $_SESSION['usuario_logado'] !== true) {
    // Redirecionar para login
    header('Location: login.php');
    exit;
}

// Atualizar última atividade
$_SESSION['ultima_atividade'] = time();

// Verificar timeout de sessão (60 minutos de inatividade)
$timeout = 60 * 60; // 60 minutos em segundos
if (isset($_SESSION['login_time']) && (time() - $_SESSION['login_time'] > $timeout)) {
    // Sessão expirou
    session_unset();
    session_destroy();
    header('Location: login.php?timeout=1');
    exit;
}

// Função para obter nome do usuário logado
function getNomeUsuario() {
    return $_SESSION['usuario_nome'] ?? 'Administrador';
}
?>