# 🎫 Sistema de Ingressos Numerados com QR Code

Sistema completo para gerenciar ingressos numerados para eventos com QR codes únicos, permitindo controle administrativo total e confirmação de presença online.

## 📋 Características

✅ **200 Ingressos Numerados** - QR codes pré-gerados (001 a 200)
✅ **Painel Administrativo** - Atribuir, editar e gerenciar nomes
✅ **Flexibilidade Total** - Troque nomes quando necessário
✅ **Confirmação Online** - Convidados confirmam presença via QR code/link
✅ **Histórico Completo** - Rastreie todas as alterações
✅ **Status em Tempo Real** - Disponível, Atribuído, Confirmado, Check-in
✅ **Busca e Filtros** - Encontre rapidamente qualquer ingresso
✅ **Estatísticas** - Visão geral do evento em tempo real

---

## 🚀 Instalação

### 1️⃣ Pré-requisitos

- XAMPP (ou similar: Apache + PHP + MySQL)
- Biblioteca PHPQRCode (incluída no sistema)
- Navegador moderno

### 2️⃣ Baixar PHPQRCode

```bash
# Baixe a biblioteca phpqrcode e extraia na pasta do projeto
# Link: https://sourceforge.net/projects/phpqrcode/

# A estrutura deve ficar assim:
evento/
├── phpqrcode/
│   ├── qrlib.php
│   └── ...
├── config_numerado.php
├── gerar_ingressos.php
└── ...
```

### 3️⃣ Configurar Banco de Dados

1. Abra o **phpMyAdmin**: `http://localhost/phpmyadmin`

2. Crie o banco de dados executando o arquivo `database_numerado.sql`

3. Ou execute manualmente:

```sql
CREATE DATABASE evento_numerado CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

Depois execute as tabelas do arquivo `database_numerado.sql`

### 4️⃣ Configurar Conexão

Edite o arquivo `config_numerado.php`:

```php
// Configurações do banco de dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'evento_numerado');
define('DB_USER', 'root');
define('DB_PASS', ''); // Sua senha do MySQL

// URL base do sistema
define('URL_BASE', 'http://172.16.253.44/layane/evento'); // ← AJUSTE AQUI
```

### 5️⃣ Copiar Arquivos

Copie todos os arquivos para a pasta do XAMPP:

```
C:\xampp\htdocs\layane\evento\
```

---

## 📂 Estrutura de Arquivos

```
evento/
├── phpqrcode/              # Biblioteca QR Code
├── qrcodes/                # QR codes gerados (criado automaticamente)
├── config_numerado.php     # Configurações
├── database_numerado.sql   # Estrutura do banco
├── gerar_ingressos.php     # Gera os 200 ingressos (usar 1x)
├── admin.php               # Painel administrativo
├── confirmar.php           # Página de confirmação
├── historico.php           # Histórico de alterações
└── README.md               # Este arquivo
```

---

## 🎯 Como Usar

### Passo 1: Gerar os 200 Ingressos

1. Acesse: `http://seu-servidor/layane/evento/gerar_ingressos.php`
2. Clique em "🚀 Gerar 200 Ingressos Agora"
3. Aguarde a geração (leva alguns segundos)
4. ✅ Pronto! Os 200 ingressos foram criados

⚠️ **IMPORTANTE**: Execute apenas UMA VEZ! Após gerar, use apenas o painel administrativo.

---

### Passo 2: Gerenciar Ingressos

Acesse o painel: `http://seu-servidor/layane/evento/admin.php`

#### 🎫 Atribuir Nome a um Ingresso

1. Localize o ingresso desejado (ex: #001)
2. Clique em "✏️ Editar"
3. Digite o nome do convidado
4. Adicione observações (opcional)
5. Clique em "💾 Salvar"

#### 🔄 Trocar o Nome

1. Localize o ingresso
2. Clique em "✏️ Editar"
3. Digite o NOVO nome
4. Salvar
5. ✅ O histórico registra a mudança automaticamente

#### 🗑️ Liberar Ingresso

1. Clique em "🗑️ Limpar"
2. Confirme
3. ✅ Ingresso volta para status "Disponível"

#### 🔗 Compartilhar QR Code

1. Clique em "🔗 Ver QR"
2. Aparece o QR code e o link
3. Clique em "📋 Copiar Link"
4. Envie para o convidado (WhatsApp, email, etc.)

---

### Passo 3: Confirmação do Convidado

O convidado recebe o link ou escaneia o QR code:

1. ✅ **Confirma presença**: Status vira "Confirmado"
2. ❌ **Recusa**: Status vira "Não vai comparecer"
3. 🔄 **Pode mudar**: A qualquer momento até o evento

---

### Passo 4: Check-in no Evento

No dia do evento:

1. Convidado apresenta o QR code
2. Você escaneia o QR code
3. Sistema mostra: "✅ Check-in Realizado!"
4. Status: "Check-in"

---

## 📊 Painel Administrativo

### Dashboard

- **Total de Ingressos**: 200
- **Disponíveis**: Sem nome atribuído
- **Atribuídos**: Com nome, aguardando confirmação
- **Confirmados**: Convidado confirmou presença
- **Check-ins**: Já entraram no evento

### Filtros e Busca

- **Por Status**: Disponível, Atribuído, Confirmado, Check-in
- **Por Número**: Digite o número do ingresso
- **Por Nome**: Busque pelo nome do convidado
- **Ordenação**: Número, Nome, Status, Mais recente

---

## 📜 Histórico de Alterações

Acesse: `http://seu-servidor/layane/evento/historico.php`

Veja TODAS as mudanças:

- ➕ **Atribuições**: Quando um nome foi atribuído
- ✏️ **Edições**: Quando um nome foi trocado
- 🗑️ **Limpezas**: Quando um ingresso foi liberado

Cada registro mostra:
- Número do ingresso
- O que foi alterado (nome anterior → nome novo)
- Data e hora exata
- Nome atual do ingresso

---

## 🎨 Fluxo Completo

```
1. ADMINISTRADOR
   ↓
   Gera 200 ingressos (1x)
   ↓
   Atribui nome ao ingresso #025
   ↓
   Copia link/QR code do #025
   ↓
   Envia para o convidado

2. CONVIDADO
   ↓
   Recebe link ou QR code
   ↓
   Abre no celular
   ↓
   Confirma presença: "Sim" ✅
   ↓
   Recebe confirmação

3. DIA DO EVENTO
   ↓
   Convidado mostra QR code
   ↓
   Organizador escaneia
   ↓
   Check-in realizado! 🎉

4. SE MUDAR
   ↓
   Administrador edita ingresso #025
   ↓
   Troca "João Silva" por "Maria Santos"
   ↓
   Link continua funcionando!
   ↓
   Histórico registra a mudança
```

---

## 🔧 Problemas Comuns

### QR Codes não estão sendo gerados

**Solução**: Verifique se a pasta `phpqrcode/` está no lugar certo e contém `qrlib.php`

### Erro ao acessar o banco

**Solução**: 
1. Verifique se o MySQL está rodando no XAMPP
2. Confirme usuário e senha no `config_numerado.php`
3. Verifique se o banco `evento_numerado` foi criado

### Link não funciona

**Solução**: Ajuste a `URL_BASE` no arquivo `config_numerado.php` para o endereço correto do seu servidor

### Pasta qrcodes/ com erro de permissão

**Solução**: 
- Windows: Dê permissão de escrita na pasta
- Linux: `chmod 777 qrcodes/`

---

## ✨ Vantagens do Sistema Numerado

### 🎯 Controle Total

- Você decide quem recebe qual número
- Pode trocar nomes sem problemas
- QR code continua válido após mudanças

### 📊 Organização

- Sabe exatamente quantos ingressos tem (200)
- Vê facilmente quais estão disponíveis
- Estatísticas em tempo real

### 🔄 Flexibilidade

- Mudou de ideia? Troque o nome!
- Convidado cancelou? Libere o ingresso!
- Reatribua para outra pessoa

### 📜 Rastreabilidade

- Histórico completo de mudanças
- Sabe quem estava antes em cada número
- Quando cada mudança foi feita

---

## 🆘 Suporte

Problemas? Verifique:

1. ✅ XAMPP rodando (Apache + MySQL)
2. ✅ Banco de dados criado
3. ✅ Arquivos na pasta correta
4. ✅ PHPQRCode instalado
5. ✅ URL_BASE configurada corretamente

---

## 📱 Compatibilidade

- ✅ Desktop (Chrome, Firefox, Edge, Safari)
- ✅ Mobile (iOS, Android)
- ✅ Tablets
- ✅ QR Code scanners

---

## 🎉 Pronto!

Seu sistema está configurado e pronto para usar! 

**Próximos passos:**

1. Gere os 200 ingressos
2. Atribua nomes aos números
3. Compartilhe os QR codes
4. Acompanhe as confirmações
5. Faça check-in no evento

**Bom evento! 🎊**
